package cn.yoofans.knowledge.center.api.remoteservice.sns;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.sns.SnsFileSyncDTO;

@AdvancedFeignClient
public interface RemoteSnsFileSyncService {

    /**
     * 保存数据
     *
     * @param snsFileSync
     * @return
     */
    Boolean insert(SnsFileSyncDTO snsFileSync);

    /**
     * 依据Id删除数据
     *
     * @param id
     * @return
     */
    Boolean delete(Long id);

    /**
     * 修改
     *
     * @param snsFileSync
     * @return
     */
    Boolean update(SnsFileSyncDTO snsFileSync);

    /**
     * 依据主键id查询数据
     *
     * @param id
     * @return
     */
    SnsFileSyncDTO findOneById(Long id);

    /**
     * 依据recordId查询数据
     *
     * @param recordId
     * @return
     */
    SnsFileSyncDTO findOneByRecordId(Long recordId);

}
