package cn.yoofans.knowledge.center.api.dto.read;

import java.io.Serializable;

/**
 * Created by zhangshun on 2018/5/25,00:17:46.
 */
public class UserReadStateDetailDTO implements Serializable {

    /**
     * 是否为阅读中 1=待开课, 2=阅读中, 3=已读完;
     */
    private Integer readState;

    /**
     * 待开课几天, 已开课几天
     */
    private Integer days;

    /**
     * 共几天
     */
    private Integer totalDays;

    private Boolean recessToday;//今天是否停课

    public Integer getReadState() {
        return readState;
    }

    public void setReadState(Integer readState) {
        this.readState = readState;
    }

    public Integer getDays() {
        return days;
    }

    public void setDays(Integer days) {
        this.days = days;
    }

    public Integer getTotalDays() {
        return totalDays;
    }

    public void setTotalDays(Integer totalDays) {
        this.totalDays = totalDays;
    }

    @Override
    public String toString() {

        StringBuilder str = new StringBuilder();

        str.append("共[").append(totalDays).append("]天 ");

        if (1 == readState) {
            str.append("还要[").append(days).append("]天开课");
        } else if (2 == readState) {
            str.append("已开课[").append(days).append("]天");
        } else if (3 == readState) {
            str.append("已读完");
        }

        return str.toString();
    }

    public Boolean getRecessToday() {
        return recessToday;
    }

    public void setRecessToday(Boolean recessToday) {
        this.recessToday = recessToday;
    }
}
