package cn.yoofans.knowledge.center.api.enums.refund;

import java.util.Objects;

/**
 * 退款状态枚举
 * Created by qiuyp
 */
public enum RefundStatusEnum {
    REFUNDING("REFUNDING", "退款中"),
    REFUND_SUCCEED("REFUND_SUCCEED", "退款成功"),
    REFUND_FAILED("REFUND_FAILED", "退款失败");

    /**
     * 代码
     */
    private String code;

    /**
     * 描述
     */
    private String desc;

    RefundStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * getByCode:(这里用一句话描述这个方法的作用). <br/>
     *
     * @param code
     * @return
     */
    public static RefundStatusEnum getByCode(String code) {
        for (RefundStatusEnum value : RefundStatusEnum.values()) {
            if (Objects.equals(code, value.getCode())) {
                return value;
            }
        }
        return null;
    }

    /**
     * 判断相等
     *
     * @param code
     * @return
     */
    public Boolean equal(String code) {
        if (null == code) return Boolean.FALSE;
        if (code.equals(this.getCode())) return Boolean.TRUE;
        return Boolean.FALSE;
    }

}
