package cn.yoofans.knowledge.center.api.remoteservice.sns;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.sns.SnsFileDetailDTO;

import java.util.List;

/**
 * 朋友圈文件详情远程调用Service
 */
@AdvancedFeignClient
public interface RemoteSnsFileDetailService {

    /**
     * 保存数据
     *
     * @param snsFileDetail
     * @return
     */
    Boolean insert(SnsFileDetailDTO snsFileDetail);

    /**
     * 批量保存数据
     *
     * @param list
     * @return
     */
    Boolean batchInsert(List<SnsFileDetailDTO> list);


    /**
     * 依据Id删除数据
     *
     * @param id
     * @return
     */
    Boolean delete(Long id);

    /**
     * 依据上传记录id删除数据
     *
     * @param recordId
     * @return
     */
    Boolean deleteByRecordId(Long recordId);


    /**
     * 依据recordId查询数据
     *
     * @param recordId
     * @return
     */
    List<SnsFileDetailDTO> findListByRecordId(Long recordId);

    /**
     * 依据id查询数据
     *
     * @param id
     * @return
     */
    SnsFileDetailDTO findOneById(Long id);

    /**
     * 依据recordIds查询数据
     *
     * @param recordIds
     * @return
     */
    List<SnsFileDetailDTO> findListByRecordIds(List<Long> recordIds);

    /**
     * 依据处理状态查询数据
     *
     * @param processStatus
     * @return
     */
    List<SnsFileDetailDTO> findListByProcessStatus(Integer processStatus);

}
