package cn.yoofans.knowledge.center.api.remoteservice.sns;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.sns.SnsInfoDTO;
import cn.yoofans.knowledge.center.api.param.sns.SnsInfoPageQueryParams;
import org.springframework.data.domain.PageImpl;

import java.util.List;

@AdvancedFeignClient
public interface RemoteSnsInfoService {

    /**
     * 保存数据
     *
     * @param list
     * @return
     */
    Boolean batchInsert(List<SnsInfoDTO> list);

    /**
     * 依据Id删除数据
     *
     * @param id
     * @return
     */
    Boolean deleteById(Long id);

    /**
     * 依据Id查询数据
     *
     * @param id
     * @return
     */
    SnsInfoDTO findOneById(Long id);

    /**
     * 分页查询数据
     *
     * @param queryParams
     * @return
     */
    PageImpl<SnsInfoDTO> findPageList(SnsInfoPageQueryParams queryParams);
}
