package cn.yoofans.knowledge.center.api.enums.market;

import java.util.Objects;

/**
 * 营销位展示形式枚举
 * Created by qiuyp
 */
public enum MarketShowTypeEnum {
    ELASTIC_LAYER(1, "弹层"),
    NOTICE_BOARD(2, "通栏");

    /**
     * 代码
     */
    private Integer code;

    /**
     * 描述
     */
    private String desc;

    MarketShowTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * getByCode:(这里用一句话描述这个方法的作用). <br/>
     *
     * @param code
     * @return
     */
    public static MarketShowTypeEnum getByCode(Integer code) {
        for (MarketShowTypeEnum value : MarketShowTypeEnum.values()) {
            if (Objects.equals(code, value.getCode())) {
                return value;
            }
        }
        return null;
    }

    /**
     * 判断相等
     *
     * @param code
     * @return
     */
    public Boolean equal(Integer code) {
        if (null == code) return Boolean.FALSE;
        if (code.equals(this.getCode())) return Boolean.TRUE;
        return Boolean.FALSE;
    }

}
