package cn.yoofans.knowledge.center.api.enums.sns;

import java.util.Objects;

/**
 * 朋友圈数据审核状态枚举
 * Created by qiuyp
 */
public enum SnsReviewEnum {

    REVIEWING(1, "审核中"),

    REVIEWED(2, "审核成功");

    /**
     * 代码
     */
    private Integer code;

    /**
     * 描述
     */
    private String desc;

    SnsReviewEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * getByCode:(这里用一句话描述这个方法的作用). <br/>
     *
     * @param code
     * @return
     */
    public static SnsReviewEnum getByCode(Integer code) {
        for (SnsReviewEnum value : SnsReviewEnum.values()) {
            if (Objects.equals(code, value.getCode())) {
                return value;
            }
        }
        return null;
    }

    /**
     * 判断相等
     *
     * @param code
     * @return
     */
    public Boolean equal(Integer code) {
        if (null == code) return Boolean.FALSE;
        if (code.equals(this.getCode())) return Boolean.TRUE;
        return Boolean.FALSE;
    }

}
