package cn.yoofans.knowledge.center.api.dto;

import cn.yoofans.knowledge.center.api.enums.market.MarketShowTypeEnum;
import cn.yoofans.knowledge.center.api.enums.market.MarketUserTypeEnum;
import cn.yoofans.knowledge.center.api.enums.market.PageIdentifierEnum;
import lombok.Data;

import java.io.Serializable;

/**
 * 营销位实体类DTO
 */
@Data
public class MarketPositionDTO extends BaseDTO implements Serializable {

    /**
     * 页面标识符 1-上课中页面/2-已结课页面/3-感想海报
     * {@link PageIdentifierEnum}
     */
    private Integer pageIdentifier;

    /**
     * 营销位展现形式,1-弹层/2-通栏
     * {@link MarketShowTypeEnum}
     */
    private Integer showType;

    /**
     * 展示周期，结课前x天起
     */
    private Integer showCycle;

    /**
     * 展示频次,x次/天
     */
    private Integer showFrequency;

    /**
     * 展示用户类型 1-未复购用户/2全部用户
     * {@link MarketUserTypeEnum}
     */
    private Integer userType;

    /**
     * 正式用户营销图
     */
    private String formalUserMarketPic;

    /**
     * 正式用户跳转链接
     */
    private String formalUserLocation;

    /**
     * 体验用户营销图
     */
    private String temporaryUserMarketPic;

    /**
     * 体验用户跳转地址
     */
    private String temporaryUserLocation;

    /**
     * 营销位状态，0-已停用,1-启用
     */
    private Integer marketStatus;


}