package cn.yoofans.knowledge.center.api.dto.sns;

import cn.yoofans.knowledge.center.api.dto.BaseDTO;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * 朋友圈文件上传实体类
 */
@Data
public class SnsFileUploadDTO extends BaseDTO {
    /**
     * 同步时间起
     */
    private Date startTime;

    /**
     * 同步时间止
     */
    private Date endTime;

    /**
     * 处理状态
     * #{@link cn.yoofans.knowledge.center.api.enums.sns.SnsProcessStatusEnum}
     */
    private Integer processStatus;

    /**
     * 操作员名称
     */
    private String operatorName;

    /**
     * 备注
     */
    private String remark;

    /**
     * 文件详情
     */
    private List<SnsFileDetailDTO> files;


}