package cn.yoofans.knowledge.center.api.enums.order;

import org.apache.commons.lang.StringUtils;

/**
 * Created by sunyan on 2018/4/11.
 */
public enum OrderTypeEnum {
    /**
     * 普通订单
     */
    ORDINARY("ORDINARY", "普通");

    /**
     * 代码
     */
    private String code;

    /**
     * 描述
     */
    private String desc;

    OrderTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     * getByCode:(这里用一句话描述这个方法的作用). <br/>
     *
     * @param code
     * @return DatabaseSchema
     */
    public static OrderTypeEnum getByCode(String code) {
        for (OrderTypeEnum enumVal : OrderTypeEnum.values()) {
            if (StringUtils.equals(code, enumVal.getCode())) {
                return enumVal;
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
