package cn.yoofans.knowledge.center.api.enums.page;

/**
 * tb_detail_page_item表
 * 详情页产品类型枚举
 * @author danke
 * @date 2018/8/6下午2:26
 */
public enum DetailPageContentTypeEnum {

    IMAGE_TEXT(0, "图文详情"),
    IMAGE(1,"图片类型");

    /**
     * 代码
     */
    private Integer code;

    /**
     * 描述
     */
    private String desc;

    DetailPageContentTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     *
     *
     * @param code
     * @return
     */
    public static DetailPageContentTypeEnum getByCode(Integer code) {
        for (DetailPageContentTypeEnum status : DetailPageContentTypeEnum.values()) {
            if (status.code.equals(code)) {
                return status;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
