package cn.yoofans.knowledge.center.api.dto.coupon;

import cn.yoofans.knowledge.center.api.dto.BaseDTO;
import org.apache.commons.lang.builder.ToStringBuilder;

import java.util.Date;
import java.util.List;

public class ActivityDTO extends BaseDTO {

    private static final long serialVersionUID = -2606201406307382125L;

    /**
     * 活动Id
     */
    private String activityId;

    /**
     * 活动标题
     */
    private String title;

    /**
     * 活动类型 1优惠券
     */
    private Integer activityType;

    /**
     * 领奖限制 1 奖品数量 2：固定周期
     */
    private Integer limitType;

    /**
     * 活动奖励数量
     */
    private Long itemSize;

    /**
     * 活动开始时间
     */
    private Date activityStartTime;

    /**
     * 活动结束时间
     */
    private Date activityEndTime;

    /**
     * 活动状态，-1:已下线；0:待上线；1:已上线
     */
    private Integer activityStatus;

    /**
     * 活动奖励
     */
    private List<ActivityAwardDTO> awards;

    public String getActivityId() {
        return activityId;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Integer getActivityType() {
        return activityType;
    }

    public void setActivityType(Integer activityType) {
        this.activityType = activityType;
    }

    public Integer getLimitType() {
        return limitType;
    }

    public void setLimitType(Integer limitType) {
        this.limitType = limitType;
    }

    public Long getItemSize() {
        return itemSize;
    }

    public void setItemSize(Long itemSize) {
        this.itemSize = itemSize;
    }

    public Date getActivityStartTime() {
        return activityStartTime;
    }

    public void setActivityStartTime(Date activityStartTime) {
        this.activityStartTime = activityStartTime;
    }

    public Date getActivityEndTime() {
        return activityEndTime;
    }

    public void setActivityEndTime(Date activityEndTime) {
        this.activityEndTime = activityEndTime;
    }

    public Integer getActivityStatus() {
        return activityStatus;
    }

    public void setActivityStatus(Integer activityStatus) {
        this.activityStatus = activityStatus;
    }

    public List<ActivityAwardDTO> getAwards() {
        return awards;
    }

    public void setAwards(List<ActivityAwardDTO> awards) {
        this.awards = awards;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}