package cn.yoofans.knowledge.center.api.enums;

/**
 * 专栏枚举类
 */
public enum ColumnStatusEnum {

    WAIT_ONLINE(0, "待上线"),

    ONLINE(1, "已上线"),

    OFFLINE(2, "已下线");

    /**
     * 代码
     */
    private Integer code;

    /**
     * 描述
     */
    private String desc;

    ColumnStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     * 依据code获取对应的专栏状态
     *
     * @param code
     * @return
     */
    public static ColumnStatusEnum getByCode(Integer code) {
        for (ColumnStatusEnum status : ColumnStatusEnum.values()) {
            if (status.code.equals(code)) {
                return status;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
