package cn.yoofans.knowledge.center.api.enums.sns;

import java.util.Objects;

/**
 * sns执行枚举
 * Created by qiuyp
 */
public enum SnsExecuteStatusEnum {

    NOT_EXECUTE(0, "未执行"),

    EXECUTEING(1, "执行中"),

    EXECUTED(2, "执行完");

    /**
     * 代码
     */
    private Integer code;

    /**
     * 描述
     */
    private String desc;

    SnsExecuteStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * getByCode:(这里用一句话描述这个方法的作用). <br/>
     *
     * @param code
     * @return
     */
    public static SnsExecuteStatusEnum getByCode(Integer code) {
        for (SnsExecuteStatusEnum value : SnsExecuteStatusEnum.values()) {
            if (Objects.equals(code, value.getCode())) {
                return value;
            }
        }
        return null;
    }

    /**
     * 判断相等
     *
     * @param code
     * @return
     */
    public Boolean equal(Integer code) {
        if (null == code) return Boolean.FALSE;
        if (code.equals(this.getCode())) return Boolean.TRUE;
        return Boolean.FALSE;
    }

}
