package cn.yoofans.knowledge.center.api.remoteservice.recess;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.card.GiftCardDto;
import cn.yoofans.knowledge.center.api.dto.recess.ReadRecessDto;
import cn.yoofans.knowledge.center.api.param.BasePageReqParam;
import cn.yoofans.knowledge.center.api.param.card.GiftCardPageParam;
import org.springframework.data.domain.PageImpl;

import java.util.Date;
import java.util.List;

/**
 * @Author danke
 * @Date :Create in 上午11:26 2018/9/6
 */
@AdvancedFeignClient
public interface RemoteReadRecessService {

    Boolean insert(ReadRecessDto dto);

    Boolean delete(Long id);

    /**
     * 查询出所有,暂时无分页
     * @return
     */
    List<ReadRecessDto> selectAllList();

    /**
     *根据时间区间参数查询
     */
    ReadRecessDto findDateScetion(Date startDate, Date endDate);

    /**
     * 分页查询
     */

    PageImpl<ReadRecessDto> pageByQuery(BasePageReqParam pageParam);
}
