package cn.yoofans.knowledge.center.api.remoteservice.sns;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.sns.SnsFileUploadDTO;
import cn.yoofans.knowledge.center.api.param.sns.SnsFileUploadPageQueryParams;
import org.springframework.data.domain.PageImpl;

import java.util.Date;
import java.util.List;

/**
 * 上传文件远程调用接口
 *
 * @author qiuyp
 */
@AdvancedFeignClient
public interface RemoteSnsFileUploadService {

    /**
     * 保存数据
     *
     * @param snsFileUpload
     * @return
     */
    Boolean insert(SnsFileUploadDTO snsFileUpload);

    /**
     * 依据Id删除数据
     *
     * @param id
     * @return
     */
    Boolean delete(Long id);

    /**
     * 依据id修改处理状态
     *
     * @param id
     * @param processStatus
     * @return
     */
    Boolean updateProcessStatusById(Long id, Integer processStatus, Date endTime);

    /**
     * 依据主键id查询数据
     *
     * @param id
     * @return
     */
    SnsFileUploadDTO findOneById(Long id);

    /**
     * 依据处理状态查询数据
     *
     * @param processStatus
     * @return
     */
    List<SnsFileUploadDTO> findListByProcessStatus(Integer processStatus);

    /**
     * 查询数据列表,按创建时间倒序排列
     *
     * @return
     */
    List<SnsFileUploadDTO> findList();

    /**
     * 分页查询数据
     *
     * @param queryParams
     * @return
     */
    PageImpl<SnsFileUploadDTO> findPageList(SnsFileUploadPageQueryParams queryParams);

}
