package cn.yoofans.knowledge.center.api.dto.coupon;

import java.io.Serializable;
import java.util.Date;

/**
 * 可用优惠券信息实体
 *
 * @author zhanghuifeng
 * @date 2018/4/23下午7:09
 */
public class CouponInfoForCanUseDto implements Serializable {

    private static final long serialVersionUID = 302574032357244993L;
    /**
     * 优惠券ID
     */
    private String couponId;

    /**
     * 使用条件类型，1:满减;2:直减
     */
    private Integer conditionType;

    /**
     * 使用条件：当为满减时，为金额（分）
     */
    private Integer conditionValue;

    /**
     * 券面额（分）
     */
    private Integer couponPrice;

    /**
     * 优惠券结束日期
     */
    private Date couponEndTime;

    public String getCouponId() {
        return couponId;
    }

    public void setCouponId(String couponId) {
        this.couponId = couponId;
    }

    public Integer getConditionType() {
        return conditionType;
    }

    public void setConditionType(Integer conditionType) {
        this.conditionType = conditionType;
    }

    public Integer getConditionValue() {
        return conditionValue;
    }

    public void setConditionValue(Integer conditionValue) {
        this.conditionValue = conditionValue;
    }

    public Integer getCouponPrice() {
        return couponPrice;
    }

    public void setCouponPrice(Integer couponPrice) {
        this.couponPrice = couponPrice;
    }

    public Date getCouponEndTime() {
        return couponEndTime;
    }

    public void setCouponEndTime(Date couponEndTime) {
        this.couponEndTime = couponEndTime;
    }
}
