package cn.yoofans.knowledge.center.api.dto.coupon;

import cn.yoofans.knowledge.center.api.param.coupon.CouponTemplateItemParams;
import org.apache.commons.lang.builder.ToStringBuilder;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 优惠券母版信息
 *
 * @author zhanghuifeng
 * @date 2018/4/23下午7:02
 */
public class CouponTemplateDto implements Serializable {

    private static final long serialVersionUID = 2543127892121852437L;
    /**
     * 主键ID
     */
    private Long id;

    /**
     * 优惠券母版ID
     */
    private String couponTemplateId;

    /**
     * 母版标题
     */
    private String title;

    /**
     * 使用条件类型，1:满减;2:直减
     */
    private Integer conditionType;

    /**
     * 使用条件：当为满减时，为金额（分）
     */
    private Integer conditionValue;


    /**
     * 券面额（分）
     */
    private Integer couponPrice;

    /**
     * 有效期类型 1领券起天数；2固定周期
     */
    private Integer validityType;

    /**
     * 领券起天数
     */
    private Integer validityDays;

    /**
     * 优惠券开始日期
     */
    private Date couponStartTime;

    /**
     * 优惠券结束日期
     */
    private Date couponEndTime;


    /**
     * 使用范围，1:定向；2:通用
     */
    private Integer useScopeType;

    /**
     * 优惠券母版和指定商品关联信息列表
     */
    private List<CouponTemplateItemParams> couponTemplateGoodsList;

    /**
     * 优惠券母版状态，-1:已下线；0:待上线；1:已上线
     */
    private Integer couponStatus;

    /**
     * 是否发放的标识 0未发放;1已发放
     */
    private Integer isHandOut;

    /**
     * 落地使用页面类型 1内容详情页 2:指定页面
     */
    private Integer pageType;

    /**
     * 当落地使用页面类型为指定页面时，落地使用页面商品类型，1 单课 2 专栏
     */
    private Integer pageItemType;

    /**
     * 落地使用页面课程或专栏表主键ID或内容详情页ID
     */
    private Long pageLocationId;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCouponTemplateId() {
        return couponTemplateId;
    }

    public void setCouponTemplateId(String couponTemplateId) {
        this.couponTemplateId = couponTemplateId;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Integer getConditionType() {
        return conditionType;
    }

    public void setConditionType(Integer conditionType) {
        this.conditionType = conditionType;
    }

    public Integer getConditionValue() {
        return conditionValue;
    }

    public void setConditionValue(Integer conditionValue) {
        this.conditionValue = conditionValue;
    }

    public Integer getCouponPrice() {
        return couponPrice;
    }

    public void setCouponPrice(Integer couponPrice) {
        this.couponPrice = couponPrice;
    }

    public Integer getValidityType() {
        return validityType;
    }

    public void setValidityType(Integer validityType) {
        this.validityType = validityType;
    }

    public Integer getValidityDays() {
        return validityDays;
    }

    public void setValidityDays(Integer validityDays) {
        this.validityDays = validityDays;
    }

    public Date getCouponStartTime() {
        return couponStartTime;
    }

    public void setCouponStartTime(Date couponStartTime) {
        this.couponStartTime = couponStartTime;
    }

    public Date getCouponEndTime() {
        return couponEndTime;
    }

    public void setCouponEndTime(Date couponEndTime) {
        this.couponEndTime = couponEndTime;
    }

    public Integer getUseScopeType() {
        return useScopeType;
    }

    public void setUseScopeType(Integer useScopeType) {
        this.useScopeType = useScopeType;
    }

    public List<CouponTemplateItemParams> getCouponTemplateGoodsList() {
        return couponTemplateGoodsList;
    }

    public void setCouponTemplateGoodsList(List<CouponTemplateItemParams> couponTemplateGoodsList) {
        this.couponTemplateGoodsList = couponTemplateGoodsList;
    }

    public Integer getCouponStatus() {
        return couponStatus;
    }

    public void setCouponStatus(Integer couponStatus) {
        this.couponStatus = couponStatus;
    }

    public Integer getIsHandOut() {
        return isHandOut;
    }

    public void setIsHandOut(Integer isHandOut) {
        this.isHandOut = isHandOut;
    }

    public Integer getPageType() {
        return pageType;
    }

    public void setPageType(Integer pageType) {
        this.pageType = pageType;
    }

    public Integer getPageItemType() {
        return pageItemType;
    }

    public void setPageItemType(Integer pageItemType) {
        this.pageItemType = pageItemType;
    }

    public Long getPageLocationId() {
        return pageLocationId;
    }

    public void setPageLocationId(Long pageLocationId) {
        this.pageLocationId = pageLocationId;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
