package cn.yoofans.knowledge.center.api.dto.order;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

import org.apache.commons.lang3.builder.ToStringBuilder;

public class OrderFundDto implements Serializable {

    private static final long serialVersionUID = 4706563654829252949L;

    /**
     * 主键ID
     */
    private Long id;

    /**
     * 小程序ID
     */
    private Long authorizerId;

    /**
     * 买家ID
     */
    private Long consumerId;

    /**
     * 订单ID
     */
    private String orderId;

    /**
     * 资金流水号
     */
    private String fundId;

    /**
     * 付款方式
     */
    private String payType;

    /**
     * 交易账号,微信支付为openid
     */
    private String account;

    /**
     * 金额，单位：分
     */
    private Integer amount;

    /**
     * 外部流水号
     */
    private String outSeqNo;

    /**
     * 资金状态，TO_PAY-待付款/SUCCESS-付款成功/FAILED-付款失败
     */
    private String fundStatus;

    /**
     * 资金业务类型，PAY-付款/REFUND-退款
     */
    private String bizType;

    /**
     * 交易完成时间
     */
    private Date finishTime;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getOrderId() {
        return orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId == null ? null : orderId.trim();
    }

    public String getPayType() {
        return payType;
    }

    public void setPayType(String payType) {
        this.payType = payType == null ? null : payType.trim();
    }

    public Long getAuthorizerId() {
        return authorizerId;
    }

    public void setAuthorizerId(Long authorizerId) {
        this.authorizerId = authorizerId;
    }

    public String getAccount() {
        return account;
    }

    public void setAccount(String account) {
        this.account = account == null ? null : account.trim();
    }

    public String getOutSeqNo() {
        return outSeqNo;
    }

    public void setOutSeqNo(String outSeqNo) {
        this.outSeqNo = outSeqNo == null ? null : outSeqNo.trim();
    }

    public String getFundStatus() {
        return fundStatus;
    }

    public void setFundStatus(String fundStatus) {
        this.fundStatus = fundStatus == null ? null : fundStatus.trim();
    }

    public String getBizType() {
        return bizType;
    }

    public void setBizType(String bizType) {
        this.bizType = bizType == null ? null : bizType.trim();
    }

    public Date getFinishTime() {
        return finishTime;
    }

    public void setFinishTime(Date finishTime) {
        this.finishTime = finishTime;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public String getFundId() {
        return fundId;
    }

    public void setFundId(String fundId) {
        this.fundId = fundId;
    }

    public Integer getAmount() {
        return amount;
    }

    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o)
            return true;
        if (o == null || getClass() != o.getClass())
            return false;
        OrderFundDto that = (OrderFundDto) o;
        return Objects.equals(id, that.id) && Objects.equals(authorizerId, that.authorizerId) && Objects
            .equals(consumerId, that.consumerId) && Objects.equals(orderId, that.orderId) && Objects
            .equals(fundId, that.fundId) && Objects.equals(payType, that.payType) && Objects
            .equals(account, that.account) && Objects.equals(amount, that.amount) && Objects
            .equals(outSeqNo, that.outSeqNo) && Objects.equals(fundStatus, that.fundStatus) && Objects
            .equals(bizType, that.bizType) && Objects.equals(finishTime, that.finishTime) && Objects
            .equals(gmtCreate, that.gmtCreate) && Objects.equals(gmtModified, that.gmtModified);
    }

    @Override
    public int hashCode() {
        return Objects
            .hash(id, authorizerId, consumerId, orderId, fundId, payType, account, amount, outSeqNo, fundStatus,
                bizType, finishTime, gmtCreate, gmtModified);
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}