package cn.yoofans.knowledge.center.api.dto.refund;

import cn.yoofans.knowledge.center.api.dto.BaseDTO;
import cn.yoofans.knowledge.center.api.enums.refund.OperatorTypeEnum;
import cn.yoofans.knowledge.center.api.enums.refund.RefundOperationStatusEnum;
import cn.yoofans.knowledge.center.api.enums.refund.RefundStatusEnum;
import lombok.Data;

import java.util.Date;

@Data
public class RefundRecordDTO extends BaseDTO {

    /**
     * 订单ID
     */
    private String orderId;

    /**
     * 退款金额 单位(分)
     */
    private Integer refundAmount;

    /**
     * 平台补贴金额 单位分
     */
    private Integer platformSubsidy;

    /**
     * 退款状态  REFUNDING 退款中 REFUNDED 退款成功 REFUND_FAIL 退款失败
     * {@link RefundStatusEnum}
     */
    private String refundStatus;

    /**
     * 操作人员类型 1用户 2管理员
     * {@link OperatorTypeEnum}
     */
    private Integer operatorType;

    /**
     * 操作人员姓名
     */
    private String operatorName;

    /**
     * 操作状态 WAIT_CALLBACK 待处理  QUERYING 查询中 SUCCESS 处理成功 FAIL 处理失败
     * {@link RefundOperationStatusEnum}
     */
    private String operationStatus;

    /**
     * 重试次数
     */
    private Integer retryTimes;

    /**
     * 退款类型 1 无理由退款 2 强制退款
     */
    private Integer refundType;

    /**
     * 接口调用时间
     */
    private Date interfaceCallTime;

    /**
     * 退款完成时间
     */
    private Date finishTime;

    /**
     * 备注
     */
    private String remark;

    /**
     * 退款错误原因
     */
    private String errorMsg;

    /**
     * 资金流水Id
     */
    private String fundId;
}