package cn.yoofans.knowledge.center.api.dto.test;

import cn.yoofans.knowledge.center.api.dto.BaseDTO;
import cn.yoofans.knowledge.center.api.enums.test.PlanBussinessTypeEnum;
import cn.yoofans.knowledge.center.api.enums.test.PlanStatusEnum;
import org.apache.commons.lang.builder.ToStringBuilder;

import java.util.Date;
import java.util.List;

/**
 * 测试计划实体类
 *
 * @author qiuyp
 */
public class TestPlanDTO extends BaseDTO {

    private static final long serialVersionUID = 4277846498559852369L;

    /**
     * abtest外码id
     */
    private String abTestId;

    /**
     * 标题
     */
    private String title;

    /**
     * 详细说明
     */
    private String description;

    /**
     * 计划开始时间
     */
    private Date startTime;

    /**
     * 计划结束时间
     */
    private Date endTime;

    /**
     * 业务类型：1=阅读计划
     * {@link PlanBussinessTypeEnum}
     */
    private Integer businessType;

    /**
     * 业务id 0:匹配所有
     */
    private Long businessId;

    /**
     * 业务期数 0:匹配所有
     */
    private Integer businessStage;

    /**
     * 计划状态 -1:已下线；0:待上线；1:已上线
     * {@link PlanStatusEnum}
     */
    private Integer status;

    /**
     * 创建者
     */
    private String creator;

    /**
     * 修改人
     */
    private String reviser;

    /**
     * 分桶列表
     */
    private List<PlanBucketDTO> bucketList;

    public String getAbTestId() {
        return abTestId;
    }

    public void setAbTestId(String abTestId) {
        this.abTestId = abTestId;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Integer getBusinessType() {
        return businessType;
    }

    public void setBusinessType(Integer businessType) {
        this.businessType = businessType;
    }

    public Long getBusinessId() {
        return businessId;
    }

    public void setBusinessId(Long businessId) {
        this.businessId = businessId;
    }

    public Integer getBusinessStage() {
        return businessStage;
    }

    public void setBusinessStage(Integer businessStage) {
        this.businessStage = businessStage;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getCreator() {
        return creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getReviser() {
        return reviser;
    }

    public void setReviser(String reviser) {
        this.reviser = reviser;
    }

    public List<PlanBucketDTO> getBucketList() {
        return bucketList;
    }

    public void setBucketList(List<PlanBucketDTO> bucketList) {
        this.bucketList = bucketList;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}