/**
 * Copyright (C), 2015-2018, XXX有限公司
 * FileName: AuthorizerMpTemplateTypeEnum
 * Author:   amu
 * Date:     2018/5/10 下午8:03
 * Description: 微信公众号模板类型枚举
 * History:
 * <author>          <time>          <version>          <desc>
 * 作者姓名           修改时间           版本号              描述
 */
package cn.yoofans.knowledge.center.api.enums;

import cn.yoofans.knowledge.center.api.dto.template.MsgDTO;
import cn.yoofans.knowledge.center.api.dto.template.WxTemplateDataValue;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 〈一句话功能简述〉<br> 
 * 〈微信公众号模板类型枚举〉
 *
 * @author amu
 * @create 2018/5/10
 * @since 1.0.0
 */
public enum AuthorizerMpTemplateTypeEnum {

    PAY_SUCCESS(1 , KeywordNumber.FOUR,"支付成功"),
    BAND_SUCCESS(3, KeywordNumber.THREE,"绑定成功通知"),
    PROFIT(4, KeywordNumber.THREE,"收益到账"),
    WITHDRAW_CASH_FAIL(5, KeywordNumber.THREE,"提现失败"),
    GET_COUPON_SUCCESS(10, KeywordNumber.THREE, "领券成功"),
    DIVISION_PROFIT(13,KeywordNumber.TWO,"分账收益到账");

    private Integer value;

    private String desc;

    private KeywordNumber keywordNumber;


    AuthorizerMpTemplateTypeEnum(Integer value, KeywordNumber keywordNumber, String desc) {
        this.value = value;
        this.desc = desc;
        this.keywordNumber = keywordNumber;
    }

    /**
     * 组装关键词
     * @param msgDTO  关键词的数据
     * @param colorObject 颜色参数
     * @return
     */
    public List<WxTemplateDataValue> TemplateMake(MsgDTO msgDTO, JSONObject colorObject){
        return keywordNumber.keywordDesign(msgDTO,colorObject);
    }


    private enum KeywordNumber{
        ONE{
            @Override
            List<WxTemplateDataValue> keywordList(MsgDTO msgDTO, JSONObject colorObject) {
                List<WxTemplateDataValue> datas = new ArrayList<>();
                WxTemplateDataValue data=new WxTemplateDataValue("keyword1", msgDTO.getKeyword1(),colorObject.getString("keyword1"));
                datas.add(data);
                return datas;
            }
        },TWO {
            @Override
            List<WxTemplateDataValue> keywordList(MsgDTO msgDTO, JSONObject colorObject) {
                List<WxTemplateDataValue> datas = ONE.keywordList(msgDTO, colorObject);
                WxTemplateDataValue data=new WxTemplateDataValue("keyword2", msgDTO.getKeyword2(),colorObject.getString("keyword2"));
                datas.add(data);
                return datas;
            }
        },THREE {
            @Override
            List<WxTemplateDataValue> keywordList(MsgDTO msgDTO, JSONObject colorObject) {
                List<WxTemplateDataValue> datas = TWO.keywordList(msgDTO, colorObject);
                WxTemplateDataValue data=new WxTemplateDataValue("keyword3", msgDTO.getKeyword3(),colorObject.getString("keyword3"));
                datas.add(data);
                return datas;
            }
        },FOUR {
            @Override
            List<WxTemplateDataValue> keywordList(MsgDTO msgDTO, JSONObject colorObject) {
                List<WxTemplateDataValue> datas = THREE.keywordList(msgDTO, colorObject);
                WxTemplateDataValue data=new WxTemplateDataValue("keyword4", msgDTO.getKeyword4(),colorObject.getString("keyword4"));
                datas.add(data);
                return datas;
            }
        },
        FIVE {
            @Override
            List<WxTemplateDataValue> keywordList(MsgDTO msgDTO, JSONObject colorObject) {
                List<WxTemplateDataValue> datas = FOUR.keywordList(msgDTO, colorObject);
                WxTemplateDataValue data=new WxTemplateDataValue("keyword5", msgDTO.getKeyword5(),colorObject.getString("keyword5"));
                datas.add(data);
                return datas;
            }
        };
        abstract List<WxTemplateDataValue> keywordList(MsgDTO msgDTO, JSONObject colorObject);

        List<WxTemplateDataValue> keywordDesign(MsgDTO msgDTO, JSONObject colorObject){
            List<WxTemplateDataValue> templateData = keywordList(msgDTO, colorObject);
            templateData.add(new WxTemplateDataValue("first", msgDTO.getFirst(),colorObject.getString("first")));
            templateData.add(new WxTemplateDataValue("remark", msgDTO.getRemark(),colorObject.getString("remark")));
            return templateData;
        }
    }



    public Integer getValue() {
        return value;
    }

    private static Map<Integer,AuthorizerMpTemplateTypeEnum> typeMap = Maps.newHashMap();

    static {
        for (AuthorizerMpTemplateTypeEnum typeEnum : AuthorizerMpTemplateTypeEnum.values()) {
            typeMap.put(typeEnum.getValue(), typeEnum);
        }
    }

    public static AuthorizerMpTemplateTypeEnum fromTemplateTypeEnum(Integer value){
        return typeMap.get(value);
    }

    @Override
    public String toString() {
        return "AuthorizerMpTemplateTypeEnum{" + "value=" + value + ", desc='" + desc + '\'' + ", keywordNumber="
            + keywordNumber + '}';
    }


}
