package cn.yoofans.knowledge.center.api.enums;

/**
 * @Author danke
 * @Date :Create in 下午8:06 2018/8/
 * 用户阅读类型
 */
public enum ConsumerReadTypeEnum {

    NEW(1, "新用户"),
    OLD(2, "老用户");

    /**
     * 代码
     */
    private Integer code;

    /**
     * 描述
     */
    private String desc;

    ConsumerReadTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     *
     *
     * @param code
     * @return
     */
    public static ConsumerReadTypeEnum getByCode(Integer code) {
        for (ConsumerReadTypeEnum status : ConsumerReadTypeEnum.values()) {
            if (status.code.equals(code)) {
                return status;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
