package cn.yoofans.knowledge.center.api.enums;

/**
 * 课程试看枚举类
 */
public enum CourseWatchableEnum {

    FORBID(0, "禁止试看"),

    ALLOW(1, "允许试看");

    /**
     * 代码
     */
    private Integer code;

    /**
     * 描述
     */
    private String desc;

    CourseWatchableEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     * 依据code获取对应的试看枚举
     *
     * @param code
     * @return
     */
    public static CourseWatchableEnum getByCode(Integer code) {
        for (CourseWatchableEnum status : CourseWatchableEnum.values()) {
            if (status.code.equals(code)) {
                return status;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
