package cn.yoofans.knowledge.center.api.enums;

import java.util.Map;

import com.google.common.collect.Maps;

/**
 * Created by sunyan on 2018/4/10.
 */
public enum PayTypeEnum {
    /**
     * 微信小程序支付
     */
    WECHATWXAPAY("WECHATWXAPAY","W" ,"微信小程序支付"),
    
    /**
     * 课堂微信公众号H5支付
     */
    WECHATH5APAY("WECHATH5APAY","H", "课堂微信公众号H5支付"),

    /**
     * 读书微信公众号H5支付
     */
    WECHATREADH5APAY("WECHATREADH5APAY","R", "读书微信公众号H5支付"),

    /**
     * 微信外部页面h5支付
     */
    WECHATOUTH5PAY("WECHATOUTH5PAY","O","微信外部页面h5支付");

    /**
     * 代码
     */
    private String code;

    /**
     * 缩写
     */
    private String suffix;

    /**
     * 描述
     */
    private String desc;

    private static Map<String, PayTypeEnum> enumMap = Maps.newHashMap();

    private static Map<String, PayTypeEnum> senumMap = Maps.newHashMap();

    static {
        for (PayTypeEnum it : PayTypeEnum.values()) {
            enumMap.put(it.code, it);
            senumMap.put(it.suffix,it);
        }
    }

    public static PayTypeEnum getEnumByCode(String code) {
        return enumMap.get(code);
    }

    public static PayTypeEnum getEnumBySuffix(String suffix) {
        return senumMap.get(suffix);
    }

    private PayTypeEnum(String code,String suffix, String desc) {
        this.code = code;
        this.suffix = suffix;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public String getSuffix() {
        return suffix;
    }
}
