package cn.yoofans.knowledge.center.api.enums.coupon;

/**
 * 优惠券母版使用条件类型
 * @author zhanghuifeng
 * @date 2018/4/24下午3:30
 */
public enum CouponTemplateConditionTypeEnum {

    MAN_SUBTRACT(1, "满减"),
    ZHI_SUBTRACT(2, "直减");
    /**
     * 代码
     */
    private Integer code;

    /**
     * 描述
     */
    private String desc;

    CouponTemplateConditionTypeEnum(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    public static CouponTemplateConditionTypeEnum getByCode(Integer code) {
        for (CouponTemplateConditionTypeEnum enumVal : CouponTemplateConditionTypeEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public Boolean equal(Integer code) {
        if (null == code) return Boolean.FALSE;
        if (code.equals(this.getCode())) return Boolean.TRUE;
        return Boolean.FALSE;
    }
}
