package cn.yoofans.knowledge.center.api.enums.read;

import java.util.Objects;

/**
 * Created by zhangshun on 2018/5/22,19:16:41.
 */
public enum UserReadStateEnum {

    NEW(0, "新用户"),

    WAITTING(1, "待开课"),

    READING(2, "阅读中"),

    FINISHED(3, "已读完");

    /**
     * 代码
     */
    private Integer code;

    /**
     * 描述
     */
    private String desc;

    UserReadStateEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * getByCode:(这里用一句话描述这个方法的作用). <br/>
     *
     * @param code
     * @return
     */
    public static UserReadStateEnum getByCode(Integer code) {
        for (UserReadStateEnum value : UserReadStateEnum.values()) {
            if (Objects.equals(code, value.getCode())) {
                return value;
            }
        }
        return null;
    }

    /**
     * 判断相等
     * @param code
     * @return
     */
    public Boolean equal(Integer code) {
        if (null == code) return Boolean.FALSE;
        if (code.equals(this.getCode())) return Boolean.TRUE;
        return Boolean.FALSE;
    }

}
