package cn.yoofans.knowledge.center.api.enums.redpoint;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * @Author danke
 * @Date :Create in 上午10:40 2018/8/10
 * 用户打卡类型
 */
public enum StudyStateTypeEnum {

        ALREADY(1,"已学"),
        REPLENISH(2,"补学");

        private int code;
        private String msg;

    StudyStateTypeEnum(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    private static Map<Integer, StudyStateTypeEnum> codeEnumMap = Maps.newHashMap();
    static {
        for (StudyStateTypeEnum it : StudyStateTypeEnum.values()) {
            codeEnumMap.put(it.code, it);
        }
    }

    /**
     *
     *
     * @param code
     * @return
     */
    public static StudyStateTypeEnum getByCode(Integer code) {
        if (null == code){
            return null;
        }
        return codeEnumMap.get(code);
    }

    public int getCode() {
        return code;
    }

    public String getMsg() {
        return msg;
    }
}
