package cn.yoofans.knowledge.center.api.enums.refund;

import java.util.Objects;

/**
 * 退款类型枚举
 * Created by qiuyp
 */
public enum RefundTypeEnum {

    FREE_REFUND(1, "无理由退款"),
    FORCE_REFUND(2, "强制退款");

    /**
     * 代码
     */
    private Integer code;

    /**
     * 描述
     */
    private String desc;

    RefundTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * getByCode:(这里用一句话描述这个方法的作用). <br/>
     *
     * @param code
     * @return
     */
    public static RefundTypeEnum getByCode(Integer code) {
        for (RefundTypeEnum value : RefundTypeEnum.values()) {
            if (Objects.equals(code, value.getCode())) {
                return value;
            }
        }
        return null;
    }

    /**
     * 判断相等
     *
     * @param code
     * @return
     */
    public Boolean equal(Integer code) {
        if (null == code) return Boolean.FALSE;
        if (code.equals(this.getCode())) return Boolean.TRUE;
        return Boolean.FALSE;
    }

}
