package cn.yoofans.knowledge.center.api.remoteservice.billboard;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.billboard.DistributeBillBoardListDTO;
import cn.yoofans.knowledge.center.api.enums.ConsumerTypeEnum;
import cn.yoofans.knowledge.center.api.param.billboard.BillBoardListPageParam;
import org.springframework.data.domain.PageImpl;

import java.util.List;

/**
 * @Author danke
 * @Date :Create in 下午8:20 2018/7/31
 */
@AdvancedFeignClient
public interface RemoteDistributeBillBoardListService {

    Long save(DistributeBillBoardListDTO dto);

    DistributeBillBoardListDTO selectByPrimaryKey(Long id);

    Boolean delete(Long id);

    PageImpl<DistributeBillBoardListDTO> findPageList(BillBoardListPageParam pageParam);

    /**
     * 根据排行榜ID、返回条数查询排行榜榜单
     * @param distributeBillboardId 排行榜ID
     * @param limitSize 限制条数
     * @return
     */
    List<DistributeBillBoardListDTO> findListForOnline(Long distributeBillboardId,Integer limitSize);

    /**
     * 根据排行榜ID 和分销员用户信息查询 排行榜榜单
     * @param distributeBillboardId 排行榜主键ID
     * @param consumerId   用户ID
     * @param consumerTypeEnum 用户类型 {@link ConsumerTypeEnum}
     * @return
     */
    DistributeBillBoardListDTO findByBillboardAndConsumer(Long distributeBillboardId, Long consumerId, ConsumerTypeEnum consumerTypeEnum);

}
