package cn.yoofans.knowledge.center.api.remoteservice.coupon;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.coupon.CouponBatchGrantDetailDto;

import java.util.List;

/**
 * @author zhanghuifeng
 * @date 2018/8/9下午8:56
 */
@AdvancedFeignClient
public interface RemoteCouponBatchGrantDetailService {

    /**
     * 批量插入
     * @param list
     * @return
     */
    Boolean batchInsert(List<CouponBatchGrantDetailDto> list);

    /**
     * 根据优惠券ID查询
     * @param couponId
     * @return
     */
    CouponBatchGrantDetailDto findByCouponId(String couponId);

    /**
     * 获取存在的优惠券ID
     * @param list
     * @return
     */
    List<String> findExistCouponId(List<String> list);

    /**
     * 更新状态
     * @param couponId
     * @param couponState
     * @return
     */
    Boolean updateState(String couponId, Integer couponState);
}
