package cn.yoofans.knowledge.center.api.remoteservice.jdgift;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.jdgiftbook.GiftBookDTO;
import cn.yoofans.knowledge.center.api.dto.jdgiftbook.GiftOrderDTO;
import cn.yoofans.knowledge.center.api.dto.jdgiftbook.PaperBookDTO;
import cn.yoofans.knowledge.center.api.param.jdgiftbook.GiftBookParams;
import cn.yoofans.knowledge.center.api.param.jdgiftbook.PaperBookParams;
import org.springframework.data.domain.PageImpl;

import java.util.List;

/**
 * @author zhangmm
 * @Description: 赠书rpc接口
 * @date 2018/9/14 0014 19:04
 */
@AdvancedFeignClient
public interface RemoteJDGiftBookService {

    public List<PaperBookDTO> getPaperBookList(PaperBookParams paperBookParams);

    public Boolean save(PaperBookParams params);

    public Boolean delete(Long id);

    public List<GiftBookDTO> getGiftBookList(GiftBookParams params);

    public Boolean saveGiftBook(GiftBookParams params);

    public Boolean deleteGiftBook(Long id);

    public GiftBookDTO selectByPrimaryKey(Long id);

    public List<PaperBookDTO> findUserListByIds(List<Long> ids);

    public List<GiftOrderDTO> getGiftOrderInfo(Long userId);

}
