package cn.yoofans.knowledge.center.api.remoteservice.read;

import java.util.Date;
import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.comment.ClockDto;
import cn.yoofans.knowledge.center.api.dto.comment.CommentStateDto;
import cn.yoofans.knowledge.center.api.param.comment.ClockParam;

/**
 * Created by zhangshun on 2018/5/23,10:45:42.
 */
@AdvancedFeignClient
public interface RemoteUserClockService {

    /**
     * 打卡
     *
     * @param param
     * @return
     */
    ClockDto clock(ClockParam param);

    /**
     * 获取用户打卡日历
     *
     * @param userId 用户ID
     * @param readId 阅读ID
     * @return
     */
    List<CommentStateDto> getClockCalendar(Long userId, Long readId);

    /**
     * 获取评论状态
     *
     * @param userId   用户ID
     * @param readId   阅读ID
     * @param courseId 课程ID
     * @return
     */
    CommentStateDto getCommentState(Long userId, Long readId, Long courseId);

    /**
     * 获取今日打卡人数
     *
     * @param readId    阅读ID
     * @param courseId  课程ID
     * @param clockDate 操作日期
     * @return
     */
    Long getClockCountByReadCourse(Long readId, Long courseId, Date clockDate);

    /**
     * 按照阅读获取用户打卡次数(排除当天打卡)
     * @param cid 用户id
     * @param readId 阅读id
     * @param readDays 阅读天数值，应在第几天阅读
     * @return
     */
    Long getUserClockTimsByReadId(Long cid, Long readId,Integer readDays);
}
