package cn.yoofans.knowledge.center.api.constant;

import org.apache.commons.lang.StringUtils;

/**
 * 微信退款常量
 *
 * @author qiuyp
 */
public class WeChatRefundConstant {

    /**
     * 退款查询接口返回错误枚举
     */
    public enum QueryErrorCodeEnum {
        SYSTEMERROR("SYSTEMERROR", "系统超时,请尝试再次掉调用API"),

        REFUNDNOTEXIST("REFUNDNOTEXIST", "订单号错误或订单状态不正确,请检查订单号是否有误以及订单状态是否正确"),

        INVALID_TRANSACTIONID("INVALID_TRANSACTIONID", "请求参数错误，检查原交易号是否存在或发起支付交易接口返回失败"),

        PARAM_ERROR("PARAM_ERROR", "请求参数错误，请检查参数再调用退款申请"),

        APPID_NOT_EXIST("APPID_NOT_EXIST", "参数中缺少APPID"),

        MCHID_NOT_EXIST("MCHID_NOT_EXIST", "参数中缺少MCHID"),

        REQUIRE_POST_METHOD("REQUIRE_POST_METHOD", "未使用post传递参数 "),

        SIGNERROR("SIGNERROR", "签名错误"),

        XML_FORMAT_ERROR("XML_FORMAT_ERROR", "XML格式错误");

        /**
         * 代码
         */
        private String code;

        /**
         * 描述
         */
        private String desc;

        QueryErrorCodeEnum(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        public String getCode() {
            return code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        /**
         * getByCode:(这里用一句话描述这个方法的作用). <br/>
         *
         * @param code
         * @return DatabaseSchema
         */
        public static QueryErrorCodeEnum getByCode(String code) {
            for (QueryErrorCodeEnum enumVal : QueryErrorCodeEnum.values()) {
                if (StringUtils.equals(code, enumVal.getCode())) {
                    return enumVal;
                }
            }
            return null;
        }
    }
}
