package cn.yoofans.knowledge.center.api.param.refund;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 退款异步通知参数
 */
@Data
public class AsyncRefundParams implements Serializable {

    /**
     * 外部流水号，取微信接口返回的退款单号refund_id
     */
    private String outSqeNo;

    /**
     * 公众账号ID
     */
    private String appId;

    /**
     * 订单号
     */
    private String orderId;

    /**
     * 商户退款单号
     */
    private String refundId;


    /**
     * 退款金额
     */
    private Integer refundFee;

    /**
     * 退款状态
     * SUCCESS-退款成功
     * CHANGE-退款异常
     * REFUNDCLOSE—退款关闭
     */
    private String refundStatus;

    /**
     * 退款入账账号
     */
    private String refundRecvAccout;

    /**
     * 退款成功时间
     */
    private Date successTime;

    /**
     * 错误信息，回调错误没有失败原因；调用查询接口失败需要填充此字段
     */
    private String errorMsg;

    /**
     * 订单金额
     */
    private Integer amount;

}
