package cn.yoofans.knowledge.center.api.dto.account;

import cn.yoofans.knowledge.center.api.dto.BaseDTO;
import org.apache.commons.lang.builder.ToStringBuilder;

import java.io.Serializable;

public class CapitalAccountDetailDTO extends BaseDTO implements Serializable {

    private static final long serialVersionUID = -6769789659471709815L;

    /**
     * 用户id
     */
    private Long consumerId;

    /**
     * 支出金额(分)
     */
    private Integer expenditureAmount;

    /**
     * 收入金额(分)
     */
    private Integer incomeAmount;

    /**
     * 操作类型，1:支出；2:收入
     */
    private Integer operateType;

    /**
     * 业务类型，1:提现；2:推广收益；3:新绑定用户收益
     */
    private Integer businessType;

    /**
     * 业务ID
     */
    private String businessId;

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public Integer getExpenditureAmount() {
        return expenditureAmount;
    }

    public void setExpenditureAmount(Integer expenditureAmount) {
        this.expenditureAmount = expenditureAmount;
    }

    public Integer getIncomeAmount() {
        return incomeAmount;
    }

    public void setIncomeAmount(Integer incomeAmount) {
        this.incomeAmount = incomeAmount;
    }

    public Integer getOperateType() {
        return operateType;
    }

    public void setOperateType(Integer operateType) {
        this.operateType = operateType;
    }

    public Integer getBusinessType() {
        return businessType;
    }

    public void setBusinessType(Integer businessType) {
        this.businessType = businessType;
    }

    public String getBusinessId() {
        return businessId;
    }

    public void setBusinessId(String businessId) {
        this.businessId = businessId;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}