package cn.yoofans.knowledge.center.api.dto.coupon;

import org.apache.commons.lang.builder.ToStringBuilder;

import java.io.Serializable;
import java.util.Date;

/**
 * 优惠券母版分页信息
 *
 * @author zhanghuifeng
 * @date 2018/4/23下午5:19
 */
public class CouponTemplatePageDto implements Serializable {

    private static final long serialVersionUID = -1999228688540822883L;
    /**
     * 主键ID
     */
    private Long id;

    /**
     * 母版标题
     */
    private String title;

    /**
     * 使用条件类型，1:满减;2:直减
     */
    private Integer conditionType;

    /**
     * 使用条件：当为满减时，为金额（分）
     */
    private Integer conditionValue;


    /**
     * 券面额（分）
     */
    private Integer couponPrice;

    /**
     * 有效期类型 1领券起天数；2固定周期
     */
    private Integer validityType;

    /**
     * 领券起天数
     */
    private Integer validityDays;

    /**
     * 优惠券开始日期
     */
    private Date couponStartTime;

    /**
     * 优惠券结束日期
     */
    private Date couponEndTime;


    /**
     * 使用范围，1:定向；2:通用
     */
    private Integer useScopeType;

    /**
     * 券状态，-1:已下线；0:待上线；1:已上线
     */
    private Integer couponStatus;

    /**
     * 是否发放的标识 0未发放;1已发放
     */
    private Integer isHandOut;

    /**
     * 优惠券母版ID
     */
    private String couponTemplateId;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Integer getConditionType() {
        return conditionType;
    }

    public void setConditionType(Integer conditionType) {
        this.conditionType = conditionType;
    }

    public Integer getConditionValue() {
        return conditionValue;
    }

    public void setConditionValue(Integer conditionValue) {
        this.conditionValue = conditionValue;
    }

    public Integer getCouponPrice() {
        return couponPrice;
    }

    public void setCouponPrice(Integer couponPrice) {
        this.couponPrice = couponPrice;
    }

    public Date getCouponStartTime() {
        return couponStartTime;
    }

    public void setCouponStartTime(Date couponStartTime) {
        this.couponStartTime = couponStartTime;
    }

    public Date getCouponEndTime() {
        return couponEndTime;
    }

    public void setCouponEndTime(Date couponEndTime) {
        this.couponEndTime = couponEndTime;
    }

    public Integer getUseScopeType() {
        return useScopeType;
    }

    public void setUseScopeType(Integer useScopeType) {
        this.useScopeType = useScopeType;
    }

    public Integer getCouponStatus() {
        return couponStatus;
    }

    public void setCouponStatus(Integer couponStatus) {
        this.couponStatus = couponStatus;
    }

    public Integer getIsHandOut() {
        return isHandOut;
    }

    public void setIsHandOut(Integer isHandOut) {
        this.isHandOut = isHandOut;
    }

    public String getCouponTemplateId() {
        return couponTemplateId;
    }

    public void setCouponTemplateId(String couponTemplateId) {
        this.couponTemplateId = couponTemplateId;
    }

    public Integer getValidityType() {
        return validityType;
    }

    public void setValidityType(Integer validityType) {
        this.validityType = validityType;
    }

    public Integer getValidityDays() {
        return validityDays;
    }

    public void setValidityDays(Integer validityDays) {
        this.validityDays = validityDays;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
