/**
 * Project Name:qiho-center-biz File Name:RefundResult.java Package Name:com.qiho.center.biz.model
 * Date:2017年7月19日下午4:27:01 Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package cn.yoofans.knowledge.center.api.dto.refund;

import org.apache.commons.lang3.builder.ToStringBuilder;

import java.io.Serializable;
import java.util.Date;

/**
 * ClassName:RefundResult <br/>
 * 退款查询结果. <br/>
 * Created by sunyan on 2018/4/10.
 */
public class RefundResultDTO implements Serializable {

    /*appId*/
    private String appId;

    /** 退款对应的订单ID */
    private String  orderId;

    /** 退款请求号，一个订单多次部分退款的时候必填 */
    private String  fundId;

    /** 退款原因 */
    private String  refundReason;

    /** 退款金额，单位：分 */
    private Integer refundAmt;

    /** 是否请求成功 */
    private Boolean isSuccess;
    /**
     * 外部流水号
     */
    private String  outTradeNo;

    /**
     * 成功时间
     */
    private Date successTime;
	/**
     * 成功:SUCCESS 失败: FAIL 退款中:PROCESSING
     */
    private String  refundStatus;

    /**
     * 错误原因
     */
    private String errorMsg;

    public static final String  REFUND_STATUS_SUCCESS = "success";
    public static final String  REFUND_STATUS_FAIL = "fail";
    public static final String  REFUND_STATUS_PROCESSING = "processing";

    /**
     * 微信返回的状态
     *
     * SUCCESS—退款成功
     * REFUNDCLOSE—退款关闭。
     * PROCESSING—退款处理中
     * CHANGE—退款异常，
     */

    private String wxRefundStatus;

    /**
     * 退款账户
     */
    private String refundRecvAccout;


    /**
     * orderId.
     *
     * @return the orderId
     */
    public String getOrderId() {
        return orderId;
    }

    /**
     * orderId.
     *
     * @param orderId the orderId to set
     */
    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    /**
     * fundId.
     *
     * @return the fundId
     */
    public String getFundId() {
        return fundId;
    }

    /**
     * fundId.
     *
     * @param fundId the fundId to set
     */
    public void setFundId(String fundId) {
        this.fundId = fundId;
    }

    /**
     * refundReason.
     *
     * @return the refundReason
     */
    public String getRefundReason() {
        return refundReason;
    }

    /**
     * refundReason.
     *
     * @param refundReason the refundReason to set
     */
    public void setRefundReason(String refundReason) {
        this.refundReason = refundReason;
    }

    /**
     * refundAmt.
     *
     * @return the refundAmt
     */
    public Integer getRefundAmt() {
        return refundAmt;
    }

    /**
     * refundAmt.
     *
     * @param refundAmt the refundAmt to set
     */
    public void setRefundAmt(Integer refundAmt) {
        this.refundAmt = refundAmt;
    }

    /**
     * isSuccess.
     *
     * @return the isSuccess
     */
    public Boolean getIsSuccess() {
        return isSuccess;
    }

    /**
     * isSuccess.
     *
     * @param isSuccess the isSuccess to set
     */
    public void setIsSuccess(Boolean isSuccess) {
        this.isSuccess = isSuccess;
    }

	public String getOutTradeNo() {
		return outTradeNo;
	}

	public void setOutTradeNo(String outTradeNo) {
		this.outTradeNo = outTradeNo;
	}

    public String getRefundStatus() {
        return refundStatus;
    }

    public void setRefundStatus(String refundStatus) {
        this.refundStatus = refundStatus;
    }

    public Date getSuccessTime() {
        return successTime;
    }

    public void setSuccessTime(Date successTime) {
        this.successTime = successTime;
    }

    public String getWxRefundStatus() {
        return wxRefundStatus;
    }

    public void setWxRefundStatus(String wxRefundStatus) {
        this.wxRefundStatus = wxRefundStatus;
    }

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getRefundRecvAccout() {
        return refundRecvAccout;
    }

    public void setRefundRecvAccout(String refundRecvAccout) {
        this.refundRecvAccout = refundRecvAccout;
    }

    public String getErrorMsg() {
        return errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
