package cn.yoofans.knowledge.center.api.enums;

/**
 * 海报标识枚举类
 */
public enum PosterMarkEnum {

    PRIVATE(0, "私有海报"),

    PUBLIC(1, "公共海报");


    /**
     * 代码
     */
    private Integer code;

    /**
     * 描述
     */
    private String desc;

    PosterMarkEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     * 依据code获取对应的课程类型
     *
     * @param code
     * @return
     */
    public static PosterMarkEnum getByCode(Integer code) {
        for (PosterMarkEnum status : PosterMarkEnum.values()) {
            if (status.code.equals(code)) {
                return status;
            }
        }
        return null;
    }

    public Boolean equal(Integer code) {
        if (null == code) return Boolean.FALSE;
        if (code.equals(this.getCode())) return Boolean.TRUE;
        return Boolean.FALSE;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
