package cn.yoofans.knowledge.center.api.enums.account;

/**
 * 账户资金流水业务类型枚举类
 */
public enum BussinessTypeEnum {

    WITHDRAW(1, "提现"),

    SPREAD_INCOME(2, "推广收益"),

    NEW_CUSTOMER_INCOME(3, "新绑定用户收益"),

    USER_REFUND(4,"用户退款");


    /**
     * 代码
     */
    private Integer code;

    /**
     * 描述
     */
    private String desc;

    BussinessTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     * 依据code获取对应的课程类型
     *
     * @param code
     * @return
     */
    public static BussinessTypeEnum getByCode(Integer code) {
        for (BussinessTypeEnum status : BussinessTypeEnum.values()) {
            if (status.code.equals(code)) {
                return status;
            }
        }
        return null;
    }

    public Boolean equal(Integer code) {
        if (null == code) return Boolean.FALSE;
        if (code.equals(this.getCode())) return Boolean.TRUE;
        return Boolean.FALSE;
    }

    public Integer getCode() {
        return code;
    }


    public String getDesc() {
        return desc;
    }

}
