package cn.yoofans.knowledge.center.api.enums.account;

/**
 * 提现目的地枚举
 * @author zhanghuifeng
 * @date 2018/5/15上午11:31
 */
public enum WithdrawTargetTypeEnum {

    WE_CHAT(1, "微信"),

    BANK(2, "银行卡");


    /**
     * 代码
     */
    private Integer code;

    /**
     * 描述
     */
    private String desc;

    WithdrawTargetTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     * 依据code获取
     *
     * @param code
     * @return
     */
    public static WithdrawTargetTypeEnum getByCode(Integer code) {
        for (WithdrawTargetTypeEnum status : WithdrawTargetTypeEnum.values()) {
            if (status.code.equals(code)) {
                return status;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
