package cn.yoofans.knowledge.center.api.enums.card;

/**
 * 专栏枚举类
 */
public enum CardRelationTypeEnum {

    REDA_PLAN(1, "阅读计划");

    /**
     * 代码
     */
    private Integer code;

    /**
     * 描述
     */
    private String desc;

    CardRelationTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     * 依据code获取对应的专栏状态
     *
     * @param code
     * @return
     */
    public static CardRelationTypeEnum getByCode(Integer code) {
        for (CardRelationTypeEnum status : CardRelationTypeEnum.values()) {
            if (status.code.equals(code)) {
                return status;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
