package cn.yoofans.knowledge.center.api.enums.course;

import java.util.Objects;

/**
 * 用户完课状态
 * @author zhanghuifeng
 * @date 2018/9/1下午1:11
 */
public enum UserCourseFinishState {

    UN_FINISH(0, "未完课"),
    FINISH(1, "已完课"),
    REPLENISH(2,"补完课");

    /**
     * 代码
     */
    private Integer code;

    /**
     * 描述
     */
    private String desc;

    UserCourseFinishState(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * getByCode:(这里用一句话描述这个方法的作用). <br/>
     *
     * @param code
     * @return
     */
    public static UserCourseFinishState getByCode(Integer code) {
        for (UserCourseFinishState value : UserCourseFinishState.values()) {
            if (Objects.equals(code, value.getCode())) {
                return value;
            }
        }
        return null;
    }
}
