package cn.yoofans.knowledge.center.api.enums.playprogress;

import java.util.Objects;

/**
 * @author zhanghuifeng
 * @date 2018/9/4下午5:07
 */
public enum UserInClassStateEnum {

    UN_CLASS(0, "未上课"),
    IN_CLASS(1, "已上课");

    /**
     * 代码
     */
    private Integer code;

    /**
     * 描述
     */
    private String desc;

    UserInClassStateEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * getByCode:(这里用一句话描述这个方法的作用). <br/>
     *
     * @param code
     * @return
     */
    public static UserInClassStateEnum getByCode(Integer code) {
        for (UserInClassStateEnum value : UserInClassStateEnum.values()) {
            if (Objects.equals(code, value.getCode())) {
                return value;
            }
        }
        return null;
    }
}
