package cn.yoofans.knowledge.center.api.enums.stat;

import java.util.Objects;

/**
 * Created by zhangshun on 2018/7/18,10:58:31.
 */
public enum UserClockTypeEnum {

    NOT(0, "待打卡"), CLOCK(1, "已打卡"), SUPPLEMENT(2, "已补卡");

    private Integer code;

    private String name;

    UserClockTypeEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static String getByCode(Integer code) {
        UserClockTypeEnum[] enums = UserClockTypeEnum.values();
        for (UserClockTypeEnum e : enums) {
            if (Objects.equals(e.getCode(), code)) {
                return e.getName();
            }
        }
        return "";
    }
}
