package cn.yoofans.knowledge.center.api.param;

import cn.yoofans.knowledge.center.api.enums.DistributionBindStatusEnum;
import cn.yoofans.knowledge.center.api.enums.UserDistributionTypeEnum;
import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * userDistribution分页查询请求参数
 * Created by qiuyp on 2018/4/9.
 */
public class UserDistributionPageReqParams extends BasePageReqParam {

    private static final long serialVersionUID = -7319915638768236479L;
    /**
     * 上级id 渠道或用户id
     */
    private Long superiorId;

    /**
     * 分销类型:CHANNEL渠道分销/USER用户分销
     * {@link UserDistributionTypeEnum}
     */
    private String distributionType;

    /**
     * {@link DistributionBindStatusEnum}
     * 绑定状态
     */
    private Integer bindStatus;

    public Long getSuperiorId() {
        return superiorId;
    }

    public void setSuperiorId(Long superiorId) {
        this.superiorId = superiorId;
    }

    public String getDistributionType() {
        return distributionType;
    }

    public void setDistributionType(String distributionType) {
        this.distributionType = distributionType;
    }

    public Integer getBindStatus() {
        return bindStatus;
    }

    public void setBindStatus(Integer bindStatus) {
        this.bindStatus = bindStatus;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
