package cn.yoofans.knowledge.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.account.CapitalAccountDto;
import cn.yoofans.knowledge.center.api.param.account.UserWithdrawParams;

/**
 * 资金账户service
 * @author zhanghuifeng
 * @date 2018/5/11上午10:22
 */
@AdvancedFeignClient
public interface RemoteCapitalAccountService {

    /**
     * 创建账户
     * @param consumerId 用户ID
     * @return boolean
     */
    Boolean createAccount(Long consumerId);

    /**
     * 根据用户ID查询账户信息
     * @param consumerId 用户ID
     * @return 账户信息
     */
    CapitalAccountDto findByConsumerId(Long consumerId);

    /**
     * 根据用户ID更新账户余额和累计推广收益基恩
     * @param promotionEarnings  推广收益
     * @param withdrawAmount     提现金额
     * @param consumerId         用户ID
     * @return int
     */
    Boolean updateAccount(Integer promotionEarnings, Integer withdrawAmount, Long consumerId);

    /**
     * 提现
     * @param params
     */
    void doWithdraw(UserWithdrawParams params) throws BizException;
}
