package cn.yoofans.knowledge.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.ColumnCourseDTO;

import java.util.List;

/**
 * Created by qiuyp on 2018/4/9.
 */
@AdvancedFeignClient
public interface RemoteColumnCourseService {

    /**
     * 新增专栏课程关联
     *
     * @param dto
     * @return
     */
    public ColumnCourseDTO add(ColumnCourseDTO dto) throws BizException;

    /**
     * 批量新增专栏课程关联
     *
     * @param datas
     * @return
     */
    public int batchAdd(List<ColumnCourseDTO> datas) throws BizException;

    /**
     * 删除专栏课程关联
     *
     * @param id
     * @return
     */
    public Boolean deleteById(Long id) throws BizException;

    /**
     * 修改专栏课程关联关系
     *
     * @param dto
     * @return
     */
    public Boolean update(ColumnCourseDTO dto) throws BizException;

    /**
     * 依据Id查询专栏课程关联信息
     *
     * @param id
     * @return
     */
    public ColumnCourseDTO findById(Long id) throws BizException;


    /**
     * 查询专栏课程列表
     *
     * @return
     */
    public List<ColumnCourseDTO> getList(Long columnId) throws BizException;

    /**
     * 修改试看状态
     *
     * @param id
     * @param watchStatus
     * @return
     */
    public Boolean updateWatchable(Long id, Integer watchStatus) throws BizException;

    /**
     * 对专栏中的课程进行拖拽排序
     *
     * @param columnId
     * @param relationId
     * @param start
     * @param end
     * @return
     */
    public Boolean sort(Long columnId, Long relationId, Long start, Long end) throws BizException;


    /**
     * 依据columnId,courseId查询专栏和课程的关联信息
     * param columnId
     *
     * @param courseId
     * @return
     */
    public ColumnCourseDTO findByColumnIdAndCourseId(Long columnId, Long courseId);

    /**
     * 依据columnId查询和该专栏关联的课程信息
     *
     * @param columnId
     * @return
     */
    public List<ColumnCourseDTO> findByColumnId(Long columnId);

}
