package cn.yoofans.knowledge.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.coupon.CouponTemplateItemDTO;

import java.util.List;

/**
 * 优惠券母版关联商品信息接口
 *
 * @author qiuyp
 */
@AdvancedFeignClient
public interface RemoteCouponTemplateItemService {

    /**
     * 根据couponTemplateId查询
     *
     * @param couponTemplateId
     * @return
     */
    List<CouponTemplateItemDTO> getListByCouponTemplateId(String couponTemplateId);


    /**
     * 依据优惠券母版id删除关联的商品信息
     *
     * @param couponTemplateId
     * @return
     */
    Boolean deleteByCouponTemplateId(String couponTemplateId);

}
