/**
 * Copyright (C), 2015-2018, XXX有限公司
 * FileName: RemoteGoodsGroupRelationService
 * Author:   amu
 * Date:     2018/4/9 下午9:29
 * Description:
 * History:
 * <author>          <time>          <version>          <desc>
 * 作者姓名           修改时间           版本号              描述
 */
package cn.yoofans.knowledge.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.GoodsGroupRelationDTO;

import java.util.List;

/**
 * 〈一句话功能简述〉<br> 
 * 〈〉
 *
 * @author amu
 * @create 2018/4/9
 * @since 1.0.0
 */
@AdvancedFeignClient
public interface RemoteGoodsGroupRelationService {
    /**
     * 按照一组商品分组id集合查询
     * @param goodsGroupIds
     * @return
     */
    List<GoodsGroupRelationDTO> findByGoodsGroupIds(List<Long> goodsGroupIds);

    /**
     * 按照单个商品分组id查询
     * @param goodsGroupId
     * @return
     */
    List<GoodsGroupRelationDTO> findByGoodsGroupId(Long goodsGroupId,Integer limit);

    /**
     * 批量插入
     * @param goodsGroupRelationDTOList
     * @return
     */

    int batchInsetGoodsGroupRelation(List<GoodsGroupRelationDTO> goodsGroupRelationDTOList);

    /**
     * 批量修改
     * @param goodsGroupRelationDTOList
     * @return
     */

    int batchUpdateGoodsGroupRelationSort(List<GoodsGroupRelationDTO> goodsGroupRelationDTOList);

    /**
     * 删除
     * @param id
     * @param goodsGroupId
     * @return
     */
    int deleteById(Long id,Long goodsGroupId);

    /**
     * 按照id查询
     * @param id
     * @return
     */
    GoodsGroupRelationDTO findById(Long id);

    /**
     * 按照位置查询
     * @param start 起始
     * @param end   终止
     * @return
     */
    List<GoodsGroupRelationDTO> findByPosition(Long start, Long end);
}
